/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.recipe.stone_mill;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.NewRegistryEvent;
import xueluoanping.teastory.registry.RecipeRegister;

public class StoneRollerRecipe
implements Recipe<RecipeWrapper> {
    protected final ResourceLocation id;
    protected final String group;
    protected final Ingredient inputItem;
    protected final NonNullList<ItemStack> outputItems;
    protected final int workTime;

    public StoneRollerRecipe(ResourceLocation idIn, String groupIn, Ingredient inputItem, NonNullList<ItemStack> outputItems, int workTime) {
        this.id = idIn;
        this.group = groupIn;
        this.inputItem = inputItem;
        this.outputItems = outputItems;
        this.workTime = workTime;
    }

    public boolean matches(RecipeWrapper inv, Level worldIn) {
        return this.inputItem.test(inv.m_8020_(0));
    }

    public ItemStack assemble(RecipeWrapper p_44001_, RegistryAccess p_267165_) {
        return !this.outputItems.isEmpty() ? ((ItemStack)this.outputItems.get(0)).m_41777_() : ItemStack.f_41583_.m_41777_();
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess p_267052_) {
        return !this.outputItems.isEmpty() ? (ItemStack)this.outputItems.get(0) : ItemStack.f_41583_;
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.getInputItem()});
    }

    public Ingredient getInputItem() {
        return this.inputItem;
    }

    public NonNullList<ItemStack> getOutputItems() {
        return this.outputItems;
    }

    public int getWorkTime() {
        return this.workTime;
    }

    public String m_6076_() {
        return this.group;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeRegister.STONE_ROLLER_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeRegister.STONE_ROLLER.get();
    }

    public static class StoneRollerRecipeSerializer
    extends NewRegistryEvent
    implements RecipeSerializer<StoneRollerRecipe> {
        private static NonNullList<ItemStack> readItems(JsonArray array) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < array.size(); ++i) {
                JsonElement item = array.get(i);
                ItemStack itemStack = item.isJsonObject() ? ShapedRecipe.m_151274_((JsonObject)((JsonObject)item)) : new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(((JsonObject)item).get("output_items").getAsString())));
                nonnulllist.add((Object)itemStack);
            }
            return nonnulllist;
        }

        public StoneRollerRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group;
            String string = group = json.has("group") ? json.get("group").getAsString() : "";
            if (!json.has("item_ingredient")) {
                throw new JsonSyntaxException("Missing input ingredient, expected to find a string or object");
            }
            JsonElement jsonelement = json.get("item_ingredient");
            Ingredient inputItem = Ingredient.m_43917_((JsonElement)jsonelement);
            if (!json.has("output_items")) {
                throw new JsonSyntaxException("Missing output, expected to find a string or object");
            }
            NonNullList<ItemStack> outputItems = json.has("output_items") ? StoneRollerRecipeSerializer.readItems(json.getAsJsonArray("output_items")) : NonNullList.m_122779_();
            int workTime = json.has("work_time") ? json.get("work_time").getAsInt() : 200;
            return new StoneRollerRecipe(recipeId, group, inputItem, outputItems, workTime);
        }

        @Nullable
        public StoneRollerRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String groupIn = buffer.m_130136_(Short.MAX_VALUE);
            Ingredient inputItem = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int i = buffer.m_130242_();
            NonNullList outputItems = NonNullList.m_122780_((int)i, (Object)ItemStack.f_41583_);
            for (int j = 0; j < i; ++j) {
                outputItems.set(j, (Object)buffer.m_130267_());
            }
            int workTime = buffer.m_130242_();
            return new StoneRollerRecipe(recipeId, groupIn, inputItem, (NonNullList<ItemStack>)outputItems, workTime);
        }

        public void toNetwork(FriendlyByteBuf buffer, StoneRollerRecipe recipe) {
            buffer.m_130070_(recipe.m_6076_());
            recipe.getInputItem().m_43923_(buffer);
            buffer.m_130130_(recipe.getOutputItems().size());
            for (ItemStack ingredient : recipe.getOutputItems()) {
                buffer.writeItemStack(ingredient, false);
            }
            buffer.m_130130_(recipe.getWorkTime());
        }
    }
}

